/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.screen;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.ShaderPackOptionList;
import net.coderbot.iris.gui.element.ShaderPackSelectionList;
import net.coderbot.iris.gui.element.widget.AbstractElementWidget;
import net.coderbot.iris.gui.element.widget.CommentedElementWidget;
import net.coderbot.iris.gui.screen.HudHideable;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class ShaderPackScreen
extends class_437
implements HudHideable {
    public static final Set<Runnable> TOP_LAYER_RENDER_QUEUE = new HashSet<Runnable>();
    private static final class_2561 SELECT_TITLE = new class_2588("pack.iris.select.title").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
    private static final class_2561 CONFIGURE_TITLE = new class_2588("pack.iris.configure.title").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
    private static final int COMMENT_PANEL_WIDTH = 314;
    private final class_437 parent;
    private final class_5250 irisTextComponent;
    private ShaderPackSelectionList shaderPackList;
    @Nullable
    private ShaderPackOptionList shaderOptionList = null;
    @Nullable
    private NavigationController navigation = null;
    private class_4185 screenSwitchButton;
    private class_2561 notificationDialog = null;
    private int notificationDialogTimer = 0;
    @Nullable
    private AbstractElementWidget<?> hoveredElement = null;
    private Optional<class_2561> hoveredElementCommentTitle = Optional.empty();
    private List<class_5481> hoveredElementCommentBody = new ArrayList<class_5481>();
    private int hoveredElementCommentTimer = 0;
    private boolean optionMenuOpen = false;
    private boolean dropChanges = false;
    private static String development = "Development Environment";
    private class_5250 developmentComponent;
    private class_5250 updateComponent;

    public ShaderPackScreen(class_437 class_4372) {
        super((class_2561)new class_2588("options.iris.shaderPackSelection.title"));
        this.parent = class_4372;
        Object object = "Iris " + Iris.getVersion();
        if (((String)object).contains("-development-environment")) {
            this.developmentComponent = new class_2585("Development Environment").method_27692(class_124.field_1065);
            object = ((String)object).replace("-development-environment", "");
        }
        this.irisTextComponent = new class_2585((String)object).method_27692(class_124.field_1080);
        if (Iris.getUpdateChecker().getUpdateMessage().isPresent()) {
            this.updateComponent = new class_2585("New update available!").method_27692(class_124.field_1060).method_27692(class_124.field_1073);
            this.irisTextComponent.method_10852((class_2561)new class_2585(" (outdated)").method_27692(class_124.field_1061));
        }
        this.refreshForChangedPack();
    }

    public void method_25394(class_4587 class_45872, int n, int n2, float f) {
        if (this.field_22787.field_1687 == null) {
            this.method_25420(class_45872);
        } else {
            this.method_25296(class_45872, 0, 0, this.field_22789, this.field_22790, 1327702819, 1327702819);
        }
        if (this.optionMenuOpen && this.shaderOptionList != null) {
            this.shaderOptionList.method_25394(class_45872, n, n2, f);
        } else {
            this.shaderPackList.method_25394(class_45872, n, n2, f);
        }
        super.method_25394(class_45872, n, n2, f);
        super.method_25394(class_45872, n, n2, f);
        ShaderPackScreen.method_27534((class_4587)class_45872, (class_327)this.field_22793, (class_2561)this.field_22785, (int)((int)((double)this.field_22789 * 0.5)), (int)8, (int)0xFFFFFF);
        if (this.notificationDialog != null && this.notificationDialogTimer > 0) {
            ShaderPackScreen.method_27534((class_4587)class_45872, (class_327)this.field_22793, (class_2561)this.notificationDialog, (int)((int)((double)this.field_22789 * 0.5)), (int)21, (int)0xFFFFFF);
        } else if (this.optionMenuOpen) {
            ShaderPackScreen.method_27534((class_4587)class_45872, (class_327)this.field_22793, (class_2561)CONFIGURE_TITLE, (int)((int)((double)this.field_22789 * 0.5)), (int)21, (int)0xFFFFFF);
        } else {
            ShaderPackScreen.method_27534((class_4587)class_45872, (class_327)this.field_22793, (class_2561)SELECT_TITLE, (int)((int)((double)this.field_22789 * 0.5)), (int)21, (int)0xFFFFFF);
        }
        if (this.isDisplayingComment()) {
            int n3 = Math.max(50, 18 + this.hoveredElementCommentBody.size() * 10);
            int n4 = (int)(0.5 * (double)this.field_22789) - 157;
            int n5 = this.field_22790 - (n3 + 4);
            GuiUtil.drawPanel(class_45872, n4, n5, 314, n3);
            this.field_22793.method_30881(class_45872, this.hoveredElementCommentTitle.orElse(class_2585.field_24366), (float)(n4 + 4), (float)(n5 + 4), 0xFFFFFF);
            for (int i = 0; i < this.hoveredElementCommentBody.size(); ++i) {
                this.field_22793.method_27517(class_45872, this.hoveredElementCommentBody.get(i), (float)(n4 + 4), (float)(n5 + 16 + i * 10), 0xFFFFFF);
            }
        }
        for (Runnable runnable : TOP_LAYER_RENDER_QUEUE) {
            runnable.run();
        }
        TOP_LAYER_RENDER_QUEUE.clear();
        if (this.developmentComponent != null) {
            this.field_22793.method_30881(class_45872, (class_2561)this.developmentComponent, 2.0f, (float)(this.field_22790 - 10), 0xFFFFFF);
            this.field_22793.method_30881(class_45872, (class_2561)this.irisTextComponent, 2.0f, (float)(this.field_22790 - 20), 0xFFFFFF);
        } else if (this.updateComponent != null) {
            this.field_22793.method_30881(class_45872, (class_2561)this.updateComponent, 2.0f, (float)(this.field_22790 - 10), 0xFFFFFF);
            this.field_22793.method_30881(class_45872, (class_2561)this.irisTextComponent, 2.0f, (float)(this.field_22790 - 20), 0xFFFFFF);
        } else {
            this.field_22793.method_30881(class_45872, (class_2561)this.irisTextComponent, 2.0f, (float)(this.field_22790 - 10), 0xFFFFFF);
        }
    }

    public boolean method_25402(double d, double d2, int n) {
        int n2 = this.field_22793.method_1727("New update available!");
        if (this.updateComponent != null && d < (double)n2 && d2 > (double)(this.field_22790 - 10) && d2 < (double)this.field_22790) {
            this.field_22787.method_1507((class_437)new class_407(bl -> {
                if (bl) {
                    Iris.getUpdateChecker().getUpdateLink().ifPresent(arg_0 -> ((class_156.class_158)class_156.method_668()).method_670(arg_0));
                }
                this.field_22787.method_1507((class_437)this);
            }, Iris.getUpdateChecker().getUpdateLink().orElse(""), true));
        }
        return super.method_25402(d, d2, n);
    }

    protected void method_25426() {
        super.method_25426();
        int n = this.field_22789 / 2 - 50;
        int n2 = this.field_22789 / 2 - 76;
        boolean bl = this.field_22787.field_1687 != null;
        this.method_37066((class_364)this.shaderPackList);
        this.method_37066((class_364)this.shaderOptionList);
        this.shaderPackList = new ShaderPackSelectionList(this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 58, 0, this.field_22789);
        if (Iris.getCurrentPack().isPresent() && this.navigation != null) {
            ShaderPack shaderPack = Iris.getCurrentPack().get();
            this.shaderOptionList = new ShaderPackOptionList(this, this.navigation, shaderPack, this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 58, 0, this.field_22789);
            this.navigation.setActiveOptionList(this.shaderOptionList);
            this.shaderOptionList.rebuild();
        } else {
            this.optionMenuOpen = false;
            this.shaderOptionList = null;
        }
        if (bl) {
            this.shaderPackList.method_31322(false);
            if (this.shaderOptionList != null) {
                this.shaderOptionList.method_31322(false);
            }
        }
        this.method_37067();
        if (this.optionMenuOpen && this.shaderOptionList != null) {
            this.method_37063((class_364)this.shaderOptionList);
        } else {
            this.method_37063((class_364)this.shaderPackList);
        }
        this.method_37063((class_364)new class_4185(n + 104, this.field_22790 - 27, 100, 20, class_5244.field_24334, class_41852 -> this.method_25419()));
        this.method_37063((class_364)new class_4185(n, this.field_22790 - 27, 100, 20, (class_2561)new class_2588("options.iris.apply"), class_41852 -> this.applyChanges()));
        this.method_37063((class_364)new class_4185(n - 104, this.field_22790 - 27, 100, 20, class_5244.field_24335, class_41852 -> this.dropChangesAndClose()));
        this.method_37063((class_364)new class_4185(n2 - 78, this.field_22790 - 51, 152, 20, (class_2561)new class_2588("options.iris.openShaderPackFolder"), class_41852 -> this.openShaderPackFolder()));
        this.screenSwitchButton = (class_4185)this.method_37063((class_364)new class_4185(n2 + 78, this.field_22790 - 51, 152, 20, (class_2561)new class_2588("options.iris.shaderPackList"), class_41852 -> {
            this.optionMenuOpen = !this.optionMenuOpen;
            this.method_25426();
        }));
        this.refreshScreenSwitchButton();
    }

    public void refreshForChangedPack() {
        if (Iris.getCurrentPack().isPresent()) {
            ShaderPack shaderPack = Iris.getCurrentPack().get();
            this.navigation = new NavigationController(shaderPack.getMenuContainer());
            if (this.shaderOptionList != null) {
                this.shaderOptionList.applyShaderPack(shaderPack);
                this.shaderOptionList.rebuild();
            }
        } else {
            this.navigation = null;
        }
        this.refreshScreenSwitchButton();
    }

    public void refreshScreenSwitchButton() {
        if (this.screenSwitchButton != null) {
            this.screenSwitchButton.method_25355((class_2561)(this.optionMenuOpen ? new class_2588("options.iris.shaderPackList") : new class_2588("options.iris.shaderPackSettings")));
            this.screenSwitchButton.field_22763 = this.optionMenuOpen || Iris.getCurrentPack().isPresent();
        }
    }

    public void method_25393() {
        super.method_25393();
        if (this.notificationDialogTimer > 0) {
            --this.notificationDialogTimer;
        }
        this.hoveredElementCommentTimer = this.hoveredElement != null ? ++this.hoveredElementCommentTimer : 0;
    }

    public boolean method_25404(int n, int n2, int n3) {
        if (n == 256) {
            if (this.navigation != null && this.navigation.hasHistory()) {
                this.navigation.back();
                return true;
            }
            if (this.optionMenuOpen) {
                this.optionMenuOpen = false;
                this.method_25426();
                return true;
            }
        }
        return super.method_25404(n, n2, n3);
    }

    public void method_29638(List<Path> list) {
        if (this.optionMenuOpen) {
            this.onOptionMenuFilesDrop(list);
        } else {
            this.onPackListFilesDrop(list);
        }
    }

    public void onPackListFilesDrop(List<Path> list) {
        List list2 = list.stream().filter(Iris::isValidShaderpack).collect(Collectors.toList());
        for (Path path : list2) {
            String string = path.getFileName().toString();
            try {
                Iris.getShaderpacksDirectoryManager().copyPackIntoDirectory(string, path);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                this.notificationDialog = new class_2588("options.iris.shaderPackSelection.copyErrorAlreadyExists", new Object[]{string}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
                this.notificationDialogTimer = 100;
                this.shaderPackList.refresh();
                return;
            }
            catch (IOException iOException) {
                Iris.logger.warn("Error copying dragged shader pack", iOException);
                this.notificationDialog = new class_2588("options.iris.shaderPackSelection.copyError", new Object[]{string}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
                this.notificationDialogTimer = 100;
                this.shaderPackList.refresh();
                return;
            }
        }
        this.shaderPackList.refresh();
        if (list2.size() == 0) {
            if (list.size() == 1) {
                var3_3 = list.get(0).getFileName().toString();
                this.notificationDialog = new class_2588("options.iris.shaderPackSelection.failedAddSingle", new Object[]{var3_3}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
            } else {
                this.notificationDialog = new class_2588("options.iris.shaderPackSelection.failedAdd").method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
            }
        } else if (list2.size() == 1) {
            var3_3 = ((Path)list2.get(0)).getFileName().toString();
            this.notificationDialog = new class_2588("options.iris.shaderPackSelection.addedPack", new Object[]{var3_3}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1054});
            this.shaderPackList.select((String)var3_3);
        } else {
            this.notificationDialog = new class_2588("options.iris.shaderPackSelection.addedPacks", new Object[]{list2.size()}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1054});
        }
        this.notificationDialogTimer = 100;
    }

    public void onOptionMenuFilesDrop(List<Path> list) {
        if (list.size() != 1) {
            this.notificationDialog = new class_2588("options.iris.shaderPackOptions.tooManyFiles").method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
            this.notificationDialogTimer = 100;
            return;
        }
        this.importPackOptions(list.get(0));
    }

    public void importPackOptions(Path path) {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            Properties properties = new Properties();
            properties.load(inputStream);
            Iris.queueShaderPackOptionsFromProperties(properties);
            this.notificationDialog = new class_2588("options.iris.shaderPackOptions.importedSettings", new Object[]{path.getFileName().toString()}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1054});
            this.notificationDialogTimer = 100;
            if (this.navigation != null) {
                this.navigation.refresh();
            }
        }
        catch (Exception exception) {
            Iris.logger.error("Error importing shader settings file \"" + path.toString() + "\"", exception);
            this.notificationDialog = new class_2588("options.iris.shaderPackOptions.failedImport", new Object[]{path.getFileName().toString()}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
            this.notificationDialogTimer = 100;
        }
    }

    public void method_25419() {
        if (!this.dropChanges) {
            this.applyChanges();
        } else {
            this.discardChanges();
        }
        this.field_22787.method_1507(this.parent);
    }

    private void dropChangesAndClose() {
        this.dropChanges = true;
        this.method_25419();
    }

    public void applyChanges() {
        ShaderPackSelectionList.BaseEntry baseEntry = (ShaderPackSelectionList.BaseEntry)this.shaderPackList.method_25334();
        if (!(baseEntry instanceof ShaderPackSelectionList.ShaderPackEntry)) {
            return;
        }
        ShaderPackSelectionList.ShaderPackEntry shaderPackEntry = (ShaderPackSelectionList.ShaderPackEntry)baseEntry;
        this.shaderPackList.setApplied(shaderPackEntry);
        String string = shaderPackEntry.getPackName();
        if (!string.equals(Iris.getCurrentPackName())) {
            Iris.clearShaderPackOptionQueue();
        }
        boolean bl = this.shaderPackList.getTopButtonRow().shadersEnabled;
        String string2 = Iris.getIrisConfig().getShaderPackName().orElse(null);
        boolean bl2 = Iris.getIrisConfig().areShadersEnabled();
        if (!string.equals(string2) || bl != bl2 || !Iris.getShaderPackOptionQueue().isEmpty() || Iris.shouldResetShaderPackOptionsOnNextReload()) {
            Iris.getIrisConfig().setShaderPackName(string);
            IrisApi.getInstance().getConfig().setShadersEnabledAndApply(bl);
        }
        this.refreshForChangedPack();
    }

    private void discardChanges() {
        Iris.clearShaderPackOptionQueue();
    }

    private void openShaderPackFolder() {
        class_156.method_668().method_673(Iris.getShaderpacksDirectoryManager().getDirectoryUri());
    }

    public void setElementHoveredStatus(AbstractElementWidget<?> abstractElementWidget, boolean bl) {
        if (bl && abstractElementWidget != this.hoveredElement) {
            this.hoveredElement = abstractElementWidget;
            if (abstractElementWidget instanceof CommentedElementWidget) {
                this.hoveredElementCommentTitle = ((CommentedElementWidget)abstractElementWidget).getCommentTitle();
                Optional<class_2561> optional = ((CommentedElementWidget)abstractElementWidget).getCommentBody();
                if (!optional.isPresent()) {
                    this.hoveredElementCommentBody.clear();
                } else {
                    String string = optional.get().getString();
                    if (string.endsWith(".")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    List list = Arrays.stream(string.split("\\. [ ]*")).map(class_2585::new).collect(Collectors.toList());
                    this.hoveredElementCommentBody = new ArrayList<class_5481>();
                    for (class_5250 class_52502 : list) {
                        this.hoveredElementCommentBody.addAll(this.field_22793.method_1728((class_5348)class_52502, 306));
                    }
                }
            } else {
                this.hoveredElementCommentTitle = Optional.empty();
                this.hoveredElementCommentBody.clear();
            }
            this.hoveredElementCommentTimer = 0;
        } else if (!bl && abstractElementWidget == this.hoveredElement) {
            this.hoveredElement = null;
            this.hoveredElementCommentTitle = Optional.empty();
            this.hoveredElementCommentBody.clear();
            this.hoveredElementCommentTimer = 0;
        }
    }

    public boolean isDisplayingComment() {
        return this.hoveredElementCommentTimer > 20 && this.hoveredElementCommentTitle.isPresent() && !this.hoveredElementCommentBody.isEmpty();
    }
}

